package gov.va.caret.pdf;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.PropsUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.support.Person;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

import javax.portlet.PortletRequest;

import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;

public class PopulatePDFImpl implements PopulatePDF{
	
	public static final String FORM = "/form/10-10CG.pdf";
	private static Log _log = LogFactoryUtil.getLog(PopulatePDFImpl.class);
	
	public void generateAndPopulatePDF(PortletRequest request, VaForm1010cgFields vaForm1010cg) throws COSVisitorException, IOException{
		
		PDDocument pdfDoc = vaForm1010cg.getPdfDoc();
			
        PDDocumentCatalog docCatalog = pdfDoc.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm(); 
        
        acroForm.setXFA(null);	     	        
        
        printFields(pdfDoc, vaForm1010cg); 
        
        String tempLocation = PropsUtil.get(CaretStrPool.FILE_TEMP_STORE);
        String name = "1010CG_" + DateUtil.newTime() + ".pdf";
   
		pdfDoc.save(tempLocation + name); // save changes to another file
		pdfDoc.close();
		
		request.setAttribute(CaretStrPool.TEN_TEN_FILE, name ); // tempLocation + name);
		
		
  }

	public void getPDF(PortletRequest resourceRequest, 
			VaForm1010cgFields vaForm1010cg, 
			ByteArrayOutputStream output) throws COSVisitorException, IOException  {
		
        vaForm1010cg.getPdfDoc().getDocumentCatalog().getAcroForm().setXFA(null);
		
		printFields( vaForm1010cg.getPdfDoc(), vaForm1010cg );
		vaForm1010cg.getPdfDoc().save( output );
		
	}
	
  
  public void printFields( PDDocument pdfDocument, VaForm1010cgFields vaForm1010cg)
  {
  	PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
      PDAcroForm acroForm = docCatalog.getAcroForm();
      List fields;
      try {
    	  fields = acroForm.getFields();
    	  Iterator fieldsIter = fields.iterator();
 
    	  _log.info(new Integer(fields.size()).toString() + " top-level fields were found on the form");
 
	      while( fieldsIter.hasNext())
	      {
	          PDField field = (PDField)fieldsIter.next();
	          processField(field, "|--", field.getPartialName(), vaForm1010cg);
	      }
	  	} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		}
  }
  
  private void processField(PDField field, String sLevel, String sParent, VaForm1010cgFields vaForm1010cg)
  {
  	List kids;
	try {
		 kids = field.getKids();
	     if(kids != null)
	     {
	      	Iterator kidsIter = kids.iterator();
	          if(!sParent.equals(field.getPartialName()))
	          {
	              sParent = sParent + "." + field.getPartialName();
	          }
	          //System.out.println(sLevel + sParent);
	          while(kidsIter.hasNext())
	          {
	               Object pdfObj = kidsIter.next();
	               if(pdfObj instanceof PDField)
	               {
	                    PDField kid = (PDField)pdfObj;
	                    processField(kid, "|  " + sLevel, sParent, vaForm1010cg);
	                }
	           }
	       }
	       else
	       {
	    	  //String outputString = sLevel + sParent + "." + field.getPartialName() + ", (" + field.getAlternateFieldName() + ") ,  type=" + field.getClass().getName();
	      	  //System.out.println(outputString);
	    	   
	    	  field.setReadonly(true);
	                    	 	      	 
	      	  Person  veteran = vaForm1010cg.getVeteran();
	      	  Person primary = vaForm1010cg.getPrimary();
	      	  Person secondary = vaForm1010cg.getSecondary();
	      	  Person secondaryTwo = vaForm1010cg.getSecondaryTwo();
	      	 
	      	  //all fields
	      	  // == Veteran Info ==
		      if(veteran!=null && ( vaForm1010cg.isCaregiverPreview() || CaretStrPool.PERSON_CATEGORY_VETERAN.equals(vaForm1010cg.getPersonCategory()) ) ){
		      	if(field.getPartialName().equals("TextField3[0]") && isNotEmpty(veteran.getLastName())){        		
		      		 field.setValue(veteran.getLastName());
		        }else if(field.getPartialName().equals("TextField3[1]") && isNotEmpty(veteran.getFirstName())){
		         	field.setValue(veteran.getFirstName());
		        }else if(field.getPartialName().equals("TextField3[2]") && isNotEmpty(veteran.getMiddleName())){
		        	field.setValue(veteran.getMiddleName());
		        }else if(field.getPartialName().equals("DateField1[0]") && veteran.getBirthDate()!=null){
		        	field.setValue(Toolbox.formatDatePdf( veteran.getBirthDate() ));
		       	}else if(field.getPartialName().equals("TextField3[3]") && isNotEmpty(veteran.getSsn())){
		       		field.setValue(veteran.getSsn());
		        }else if(field.getPartialName().equals("male[0]") && isNotEmpty(veteran.getGender()) && veteran.getGender().equals(CaretStrPool.GENDER_TYPE_MALE)){
		      		((PDCheckbox) field).check();
		        }else if(field.getPartialName().equals("female[0]") && isNotEmpty(veteran.getGender()) && veteran.getGender().equals(CaretStrPool.GENDER_TYPE_FEMALE)){
		        	((PDCheckbox) field).check();
		        }else if(field.getPartialName().equals("TextField3[4]") && isNotEmpty(veteran.getAddress())){ //address
		       		field.setValue(veteran.getAddress());
		        }else if(field.getPartialName().equals("TextField3[5]") && isNotEmpty(veteran.getCity())){ //city
		        	field.setValue(veteran.getCity());
		       	}else if(field.getPartialName().equals("TextField3[6]") && isNotEmpty(veteran.getState())){ //state
		       		field.setValue(veteran.getState());
		        }else if(field.getPartialName().equals("TextField3[7]") && veteran.getZip()!=null){ //zip
		        	field.setValue(String.valueOf(veteran.getZip()));
		        }else if(field.getPartialName().equals("TextField3[8]") && isNotEmpty(veteran.getPhone())){ // phone
		        	field.setValue(veteran.getPhone());
		        }else if(field.getPartialName().equals("TextField3[9]") && isNotEmpty(veteran.getPhone2())){ //cell phone
		        	field.setValue(veteran.getPhone2());                	
		       	}else if(field.getPartialName().equals("TextField3[10]") && isNotEmpty(vaForm1010cg.getVaMedicalCenter()) ){ //va med center/clinic where you plan to receive treatment - TODO
		       		field.setValue(vaForm1010cg.getVaMedicalCenter());
		        }else if(field.getPartialName().equals("TextField3[11]") && isNotEmpty(veteran.getEmail())){ //email
		        	field.setValue(veteran.getEmail());
		        }else if(field.getPartialName().equals("enrolledYes[0]") && vaForm1010cg.isVaHealthEnrolledYes()){ //enrolled in va healthcare - yes
		        	((PDCheckbox) field).check();
		        }else if(field.getPartialName().equals("enrolledNo[0]") && vaForm1010cg.isVaHealthEnrolledNo()){ // enrolled in va healthcare - no
		        	((PDCheckbox) field).check();
		       	}else if(field.getPartialName().equals("TextField3[12]") && isNotEmpty(vaForm1010cg.getLastTreatmentPlace())){
		         	field.setValue(vaForm1010cg.getLastTreatmentPlace());
		        }else if(field.getPartialName().equals("hospital[0]") && vaForm1010cg.isHospital()){ //hospital
		         	((PDCheckbox) field).check();
		        }else if(field.getPartialName().equals("clinic[0]") && vaForm1010cg.isClinic()){ // clinic
		       		((PDCheckbox) field).check();
		        }
		      }
	        	 
	      	 
		      // == Primary Caregiver ==
		      if(primary!=null && ( vaForm1010cg.isVeteranPreview() || CaretStrPool.PERSON_CATEGORY_PRIMARY.equals(vaForm1010cg.getPersonCategory()) ) )
		      {
		    	 if(field.getPartialName().equals("TextField3[13]") && isNotEmpty(primary.getMiddleName())){
	         		 field.setValue(primary.getMiddleName());
	         	 }else if(field.getPartialName().equals("TextField3[14]") && isNotEmpty(primary.getFirstName())){
	        		 field.setValue(primary.getFirstName());
	        	 }else if(field.getPartialName().equals("TextField3[15]") && isNotEmpty(primary.getLastName())){
			        	field.setValue(primary.getLastName());
		         }else if(field.getPartialName().equals("TextField3[16]") && isNotEmpty(primary.getSsn())){
	         		 field.setValue(primary.getSsn());
	         	 }else if(field.getPartialName().equals("DateField2[0]") && primary.getBirthDate()!=null){
	         		 field.setValue(Toolbox.formatDatePdf( primary.getBirthDate()) );
	         	 }else if(field.getPartialName().equals("cgmale[0]") && isNotEmpty(primary.getGender()) && primary.getGender().equals(CaretStrPool.GENDER_TYPE_MALE)){
	         		 ((PDCheckbox) field).check();
	        	 }else if(field.getPartialName().equals("cgfemale[0]") && isNotEmpty(primary.getGender()) && primary.getGender().equals(CaretStrPool.GENDER_TYPE_FEMALE)){
	        		((PDCheckbox) field).check();
	         	 }else if(field.getPartialName().equals("TextField3[17]") && isNotEmpty(primary.getAddress())){
	        		field.setValue(primary.getAddress());
	         	 }else if(field.getPartialName().equals("TextField3[18]") && isNotEmpty(primary.getCity())){//city
	         		field.setValue(primary.getCity());
	        	 }else if(field.getPartialName().equals("TextField3[19]") && isNotEmpty(primary.getState())){//state
	        		field.setValue(primary.getState());
	         	 }else if(field.getPartialName().equals("TextField3[20]") && isNotEmpty(String.valueOf(primary.getZip()))){//zip
	         		field.setValue(String.valueOf(primary.getZip()));
	         	 }else if(field.getPartialName().equals("TextField3[25]") && isNotEmpty(primary.getPhone())){ //phone
	         		field.setValue(primary.getPhone());
	         	 }else if(field.getPartialName().equals("TextField3[26]") && isNotEmpty(primary.getPhone2())){ //cell phone
	         		field.setValue(primary.getPhone2());                	
	        	 }else if(field.getPartialName().equals("TextField3[27]") && isNotEmpty(vaForm1010cg.getPrimaryRelationship())){ 
	        		 field.setValue(vaForm1010cg.getPrimaryRelationship());
	         	 }else if(field.getPartialName().equals("TextField3[28]") && isNotEmpty(primary.getEmail())){
	         		field.setValue(primary.getEmail());
	         	 }else if(field.getPartialName().equals("enrolledMedYes[0]") && vaForm1010cg.isMediEnrolled()){ //enrolled in medicade/medicare - yes
	 	       		((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("enrolledMedNo[0]") && vaForm1010cg.isNotMediEnrolled()){ //enrolled in medicade/medicare - no
		         	((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("otherhiName[0]") && isNotEmpty(vaForm1010cg.getOtherHealthInsurance())){ //other health insurance name
		         	field.setValue(vaForm1010cg.getOtherHealthInsurance());
		         }else if(field.getPartialName().equals("otherhiYes[0]") && vaForm1010cg.isOtherHealthInsuranceYes()){ //other health insurance - yes
		       		((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("otherhiNo[0]") && vaForm1010cg.isOtherHealthInsuranceNo()){ //other health insurance - no
		         	((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("familyYes[0]") && vaForm1010cg.isPrimaryFamily()){ //I certify that I am a family member
	        		((PDCheckbox) field).check();
	         	 }else if(field.getPartialName().equals("familyNo[0]") && vaForm1010cg.isPrimaryNotFamily()){ //I certify that I am not a family member
	         		 ((PDCheckbox) field).check();
	         	 }
		      }
	      	
		      // == Secondary Caregiver ==
		      if(secondary!=null && ( vaForm1010cg.isVeteranPreview() || CaretStrPool.PERSON_CATEGORY_SECONDARY.equals(vaForm1010cg.getPersonCategory() ) ) )
		      {
		    	 if(field.getPartialName().equals("TextField3[21]") && isNotEmpty(secondary.getLastName())){
	      			field.setValue(secondary.getLastName());
		         }else if(field.getPartialName().equals("TextField3[22]") && isNotEmpty(secondary.getFirstName())){
		         	field.setValue(secondary.getFirstName());
		         }else if(field.getPartialName().equals("TextField3[23]") && isNotEmpty(secondary.getMiddleName())){
		        	 field.setValue(secondary.getMiddleName());
		         }else if(field.getPartialName().equals("DateField4[0]") && secondary.getBirthDate()!=null){
		        	 field.setValue(Toolbox.formatDatePdf( secondary.getBirthDate() ) );
		         }else if(field.getPartialName().equals("TextField3[24]") && isNotEmpty(secondary.getSsn())){
			           	field.setValue(secondary.getSsn());
			     }else if(field.getPartialName().equals("secondMale[0]") && isNotEmpty(secondary.getGender()) && secondary.getGender().equals(CaretStrPool.GENDER_TYPE_MALE)){
		        	 ((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("secondFemale[0]") && isNotEmpty(secondary.getGender()) && secondary.getGender().equals(CaretStrPool.GENDER_TYPE_FEMALE)){
		        	 ((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("TextField3[29]") && isNotEmpty(secondary.getAddress())){
		        	 field.setValue(secondary.getAddress());
		         }else if(field.getPartialName().equals("TextField3[30]") && isNotEmpty(secondary.getCity())){ //city
		        	 field.setValue(secondary.getCity());
		         }else if(field.getPartialName().equals("TextField3[31]") && isNotEmpty(secondary.getState())){ //state
		        	 field.setValue(secondary.getState());
		         }else if(field.getPartialName().equals("TextField3[32]") && isNotEmpty(String.valueOf(secondary.getZip()))){ //zip
		        	 field.setValue(String.valueOf(secondary.getZip()));
		         }else if(field.getPartialName().equals("TextField3[33]") && isNotEmpty(secondary.getPhone2())){ //cell phone
		        	 field.setValue(secondary.getPhone2());                	
		         }else if(field.getPartialName().equals("TextField3[34]") && isNotEmpty(secondary.getPhone())){ //phone
		        	 field.setValue(secondary.getPhone());
		         }else if(field.getPartialName().equals("TextField3[35]") && isNotEmpty(vaForm1010cg.getSecondaryRelationship())){
		        	 field.setValue(vaForm1010cg.getSecondaryRelationship());
		         }else if(field.getPartialName().equals("TextField3[36]") && isNotEmpty(secondary.getEmail())){
		        	 field.setValue(secondary.getEmail());
		         }else if(field.getPartialName().equals("secondfamilyYes[0]") && vaForm1010cg.isSecondaryFamily()){ //I certify that I am a family member
			        ((PDCheckbox) field).check();
		          }else if(field.getPartialName().equals("secondfamilyNo[0]") && vaForm1010cg.isSecondaryNotFamily()){ //I certify that I am not a family member
		          	((PDCheckbox) field).check();
		          }
	      		}
	      	

	          	// == Secondary Caregiver Two ==
		      	if(secondaryTwo!=null && ( vaForm1010cg.isVeteranPreview() || CaretStrPool.PERSON_CATEGORY_SECONDARYTWO.equals(vaForm1010cg.getPersonCategory()) ) )
		      	{	      	 
	      		  if(field.getPartialName().equals("TextField3[37]") && isNotEmpty(secondaryTwo.getLastName())){
		          	field.setValue(secondaryTwo.getLastName());
		          }else if(field.getPartialName().equals("TextField3[38]") && isNotEmpty(secondaryTwo.getFirstName())){
		          	field.setValue(secondaryTwo.getFirstName());
		          }else if(field.getPartialName().equals("TextField3[39]") && isNotEmpty(secondaryTwo.getMiddleName())){
		           	field.setValue(secondaryTwo.getMiddleName());
		          }else if(field.getPartialName().equals("DateField5[0]") && secondaryTwo.getBirthDate()!=null){
			        field.setValue( Toolbox.formatDatePdf(secondaryTwo.getBirthDate()) );
			      }else if(field.getPartialName().equals("TextField3[40]") && isNotEmpty(secondaryTwo.getSsn())){
		            field.setValue(secondaryTwo.getSsn());
		          }else if(field.getPartialName().equals("secondaryMale[0]") && isNotEmpty(secondaryTwo.getGender()) && secondaryTwo.getGender().equals(CaretStrPool.GENDER_TYPE_MALE)){
		        	((PDCheckbox) field).check();
		          }else if(field.getPartialName().equals("secondaryFemale[0]") && isNotEmpty(secondaryTwo.getGender()) && secondaryTwo.getGender().equals(CaretStrPool.GENDER_TYPE_FEMALE)){
		          	((PDCheckbox) field).check();
		          }else if(field.getPartialName().equals("TextField3[41]") && isNotEmpty(secondaryTwo.getAddress())){ //address
		          	field.setValue(secondaryTwo.getAddress());
		          }else if(field.getPartialName().equals("TextField3[42]") && isNotEmpty(secondaryTwo.getCity())){ //city
		           	field.setValue(secondaryTwo.getCity());
		          }else if(field.getPartialName().equals("TextField3[43]") && isNotEmpty(secondaryTwo.getState())){ //state
		          	field.setValue(secondaryTwo.getState());
		          }else if(field.getPartialName().equals("TextField3[44]") && isNotEmpty(String.valueOf(secondaryTwo.getZip()))){ //zip
		           	field.setValue(String.valueOf(secondaryTwo.getZip()));
		          }else if(field.getPartialName().equals("TextField3[45]") && isNotEmpty(secondaryTwo.getPhone())){ //phone
		           	field.setValue(secondaryTwo.getPhone());
		          }else if(field.getPartialName().equals("TextField3[46]") && isNotEmpty(secondaryTwo.getPhone2())){ //cell phone
		           	field.setValue(secondaryTwo.getPhone2());                	
		          }else if(field.getPartialName().equals("TextField3[47]") && isNotEmpty(vaForm1010cg.getSecondaryTwoRelationship())){ //secondaryTwo relationship to veteran
		          	field.setValue(vaForm1010cg.getSecondaryTwoRelationship());
		          }else if(field.getPartialName().equals("TextField3[48]") && isNotEmpty(secondaryTwo.getEmail())){
		           	field.setValue(secondaryTwo.getEmail());
		          }else if(field.getPartialName().equals("secondaryfamilyYes[0]") && vaForm1010cg.isSecondaryTwoFamily()){ //I certify that I am a family member
			       	((PDCheckbox) field).check();
		         }else if(field.getPartialName().equals("secondaryfamilyNo[0]") && vaForm1010cg.isSecondaryTwoNotFamily()){ //I certify that I am not a family member
		         	((PDCheckbox) field).check();
		         }
		      	}
		      	
	       }
		} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		}
  }
  
  private boolean isNotEmpty(String str){
  	if(str != null && !str.trim().isEmpty()){
  		return true;
  	}else{
  		return false;
  	}  	
  }
  
  
   /*
    * DO NOT DELETE ----- FOR REFERENCE
    */
   /*

    ----> Veteran Form Info
	|  |  |--form1[0].#subform[7].TextField3[0], (Attention: Complete the application (print or typewritten only) and mail it to: Program of Comprehensive Assistance for Family Caregivers, Health Eligibility Center, 2957 Clairmont Road N E, Suite 200, Atlanta, Georgia 30329-1647, for expedited processing; or, hand carry it to your local V A. Medical Center Caregiver Support Coordinator (C S C). The date the application is received by V A. is the date the application process begins. At this time V A. does not provide the Program of Comprehensive Assistance for Family Caregivers to Veterans / Servicemembers and Family Caregivers living in a foreign country. SECTION 1 - VETERAN / SERVICEMEMBER. Last Name. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[1], (First Name. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[2], (Middle Name. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].DateField1[0], (Date of Birth. Enter 2 digit month, 2 digit day and 4 digit year.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[3], (Social Security Number. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].male[0], (Gender. Male.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[7].female[0], (Gender. Female.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[7].DateField8[0], (Date of Signature. Enter 2 digit month, 2 digit day and 4 digit year.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[4], (Current Street Address. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[5], (City. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[6], (State. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[7], (Zip Code.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[8], (Telephone Number, including area code. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[9], (Cell Number, including area code. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[10], (Name of V. A. medical center or clinic where you receive or plan to receive health care services. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[11], (Email Address. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].enrolledYes[0], (Enrolled in V. A. Health Care? Yes.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[7].enrolledNo[0], (Enrolled in V. A. Health Care? No.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[7].TextField3[12], (Name of facility where you last received medical treatment. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].hospital[0], (Name of facility where you last received medical treatment. Hospital. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[7].clinic[0], (Clinic.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[7].SignatureField5[0], (I certify that I give consent to the individual(s) named in this application to perform personal care services for me upon being approved as Primary and/or Secondary Caregiver(s) in the Program of Comprehensive Assistance for Family Caregivers. I certify that the information above is correct and true to the best of my knowledge and belief. Veteran / Servicemember / Representative / P O A. Signature. This is a digital signature.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField
	
  	------> Primary Caregiver Info
	|  |  |--form1[0].#subform[7].TextField3[13], (Middle Name. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[14], (First Name. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[15], (SECTION 2 - PRIMARY FAMILY CAREGIVER. Last Name. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[16], (Social Security Number. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].DateField2[0], (Date of Birth. Enter 2 digit month, 2 digit day and 4 digit year.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].cgmale[0], (Gender. Male.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[7].cgfemale[0], (Female.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[7].TextField3[17], (Current Street Address. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[18], (City. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[19], (State. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[7].TextField3[20], (Zip Code.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[25], (Telephone Number, including area code. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[26], (Cell Number, including area code. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[27], (Relationship to Veteran (for example Spouse, Parent, Child, Other).) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[28], (Email Address. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].enrolledMedYes[0], (Enrolled in Medicaid or Medicare? Yes.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[8].enrolledMedNo[0], (Enrolled in Medicaid or Medicare? No.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[8].otherhiName[0], (Other Health Insurance Name.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].otherhiYes[0], (Other Health Insurance? Yes.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[8].otherhiNo[0], (Other Health Insurance? No.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[8].familyYes[0], (Check one. I certify that I am a family member of the Veteran or Servicemember named in this application.  ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[8].familyNo[0], (I certify I am not a family member and I reside with the Veteran or Servicemember or will do so upon approval.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[8].SignatureField2[0], (I certify that I am at least 18 years of age. I agree to perform personal care services as the Primary Family Caregiver for the Veteran or Servicemember named on this application. I understand that the Veteran may revoke my designation as Primary Family Caregiver at any time and that the Secretary of the Department of Veterans Affairs (or designee) may remove me from this position immediately if I fail to comply with the Program requirements as defined by law. I understand that participation in the Program of Comprehensive Assistance for Family Caregivers does not create an employment relationship with the Department of Veterans Affairs. I certify that the information above is correct and true to the best of my knowledge and belief. Primary Family Caregiver Signature. This is a digital signature) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField

  	-------> Secondary Caregiver 1 Info
	|  |  |--form1[0].#subform[8].TextField3[21], (SECTION 3 - SECONDARY FAMILY CAREGIVER - Complete if appointing a Secondary Caregiver. Last Name. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[22], (First Name. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[23], (Middle Name. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].DateField4[0], (Date of Birth. Enter 2 digit month, 2 digit day and 4 digit year.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[24], (Social Security Number. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].secondMale[0], (Gender. Male.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[8].secondFemale[0], (Gender. Female.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[8].DateField3[0], (Date of Signature. Enter 2 digit month, 2 digit day and 4 digit year.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[29], (Current Street Address. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[30], (City. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[31], (State. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[32], (Zip Code.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[33], (Cell Number, including area code. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[34], (Telephone Number, including area code. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[35], (Relationship to Veteran (for example Spouse, Parent, Child, Other).) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[8].TextField3[36], (Email Address. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].secondfamilyYes[0], (Check one. I certify that I am a family member of the Veteran or Servicemember named in this application.  ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[9].secondfamilyNo[0], (I certify I am not a family member and I reside with the Veteran or Servicemember or will do so upon approval.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[9].SignatureField3[0], (I certify that I am at least 18 years of age. I agree to perform personal care services as the Secondary Family Caregiver for the Veteran or Servicemember named on this application. I understand that the Veteran may revoke my designation as Secondary Family Caregiver at any time and that the Secretary of the Department of Veterans Affairs (or designee) may remove me from this position immediately if I fail to comply with the Program requirements as defined by law. I certify that the information above is correct and true to the best of my knowledge and belief. Secondary Caregiver Signature. This is a digital signature.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField

  	---------> Secondary Caregiver 2 Info
	|  |  |--form1[0].#subform[9].TextField3[37], (SECONDARY FAMILY CAREGIVER - Complete if appointing more than one Secondary Caregiver. Last Name. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].TextField3[38], (First Name. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].TextField3[39], (Middle Name. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].DateField5[0], (Date of Birth. Enter 2 digit month, 2 digit day and 4 digit year.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].TextField3[40], (Social Security Number. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].secondaryMale[0], (Gender. Male.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[9].secondaryFemale[0], (Gender. Female.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[9].TextField3[41], (Current Street Address. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].TextField3[42], (City. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].TextField3[43], (State. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].TextField3[44], (Zip Code.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].TextField3[45], (Telephone Number, including area code. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].TextField3[46], (Cell Number, including area code. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].TextField3[47], (Relationship to Veteran (for example Spouse, Parent, Child, Other).) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].TextField3[48], (Email address. ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].DateField7[0], (Date of Signature. Enter 2 digit month, 2 digit day and 4 digit year.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].secondaryfamilyYes[0], (Check one. I certify that I am a family member of the Veteran or Servicemember named in this application.  ) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[9].secondaryfamilyNo[0], (I certify I am not a family member and I reside with the Veteran or Servicemember or will do so upon approval.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox
	|  |  |--form1[0].#subform[9].DateField6[0], (Date of Signature. Enter 2 digit month, 2 digit day and 4 digit year.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDTextbox
	|  |  |--form1[0].#subform[9].SignatureField4[0], (I certify that I am at least 18 years of age. I agree to perform personal care services as the Secondary Family Caregiver for the Veteran or Servicemember named on this application. I understand that the Veteran may revoke my designation as Secondary Family Caregiver at any time and that the Secretary of the Department of Veterans Affairs (or designee) may remove me from this position immediately if I fail to comply with the Program requirements as defined by law. I certify that the information above is correct and true to the best of my knowledge and belief. Additional Secondary Caregiver Signature. This is a digital signature.) ,  type=org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField
  */
  
}
